/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.java;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

abstract class VWJavaBaseDialog
extends VWModalDialog
implements ActionListener {
    public static final int STATUS_CANCEL = 0;
    public static final int STATUS_OK = 1;
    protected int m_nStatus = 0;
    protected VWXMLWrapper m_xmlWrapper = null;
    protected ClassLoader m_customClassLoader = null;
    protected JTextField m_sourceFileTextField = null;
    protected JList m_methodList = null;
    protected JButton m_okButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;

    public VWJavaBaseDialog(Frame parent, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parent);
        try {
            if (componentDescriptor != null && componentDescriptor.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(componentDescriptor);
            }
            this.m_customClassLoader = classLoader;
            if (this.m_customClassLoader == null) {
                this.m_customClassLoader = this.getClass().getClassLoader();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public VWJavaBaseDialog(Dialog parent, String componentDescriptor, ClassLoader classLoader) throws Exception {
        super(parent);
        try {
            if (componentDescriptor != null && componentDescriptor.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(componentDescriptor);
            }
            this.m_customClassLoader = classLoader;
            if (this.m_customClassLoader == null) {
                this.m_customClassLoader = this.getClass().getClassLoader();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected JPanel getButtonPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add(this.m_okButton);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_ok, VWResource.s_ok);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add(this.m_cancelButton);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add(this.m_helpButton);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMethodList(String className) {
        try {
            if (className == null) {
                return;
            }
            if ((className = className.trim()).length() > 0) {
                Class<?> importClass;
                this.setCursor(Cursor.getPredefinedCursor(3));
                ClassLoader classLoader = this.getCustomClassLoader();
                if (classLoader != null && (importClass = classLoader.loadClass(className = this.changeStringToClassName(className))) != null) {
                    DefaultListModel<Method> listModel = new DefaultListModel<Method>();
                    Method[] methods = importClass.getDeclaredMethods();
                    for (int nIndex = 0; nIndex < methods.length; ++nIndex) {
                        if (!Modifier.isPublic(methods[nIndex].getModifiers()) || methods[nIndex].getName().startsWith("PECM")) continue;
                        listModel.addElement(methods[nIndex]);
                    }
                    this.m_methodList.setModel(listModel);
                    this.m_methodList.addFocusListener(new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            int[] indices;
                            JList list;
                            Object source = e.getSource();
                            if (source != null && source instanceof JList && (list = (JList)source).getModel().getSize() > 0 && ((indices = list.getSelectedIndices()) == null || indices.length == 0)) {
                                list.setSelectedIndex(0);
                            }
                        }
                    });
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = VWResource.s_errorDuringClassIntrospection.toString(ex.getLocalizedMessage());
            JOptionPane.showMessageDialog(this.m_parent, message, VWResource.s_error, 0);
            this.m_methodList.setModel(new DefaultListModel());
            this.m_okButton.setEnabled(false);
            this.m_okButton.setFocusable(false);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected ClassLoader getCustomClassLoader() {
        try {
            String jarFilePath = this.m_sourceFileTextField.getText().trim();
            if (jarFilePath != null && jarFilePath.length() > 0) {
                File jarFile = new File(jarFilePath);
                URL[] urls = new URL[]{jarFile.toURL()};
                return new URLClassLoader(urls, this.m_customClassLoader);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_customClassLoader;
    }

    protected String changeStringToClassName(String className) {
        if (className != null && className.length() > 0) {
            if ((className = className.replace('/', '.')).endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            return className;
        }
        return null;
    }

    protected String changeClassNameToString(String className) {
        if (className != null && className.length() > 0) {
            if (!(className = className.replace('.', '/')).endsWith(".class")) {
                className = className + ".class";
            }
            return className;
        }
        return null;
    }
}

